#! /bin/sh
#
# arms          Start Agilent Remote Monitoring System
#
# Author:       Glenn Engel
#
# description: 
#
# processname: arms
# pidfile: /var/run/arms.pid
# config: 


# Source function library.
. /etc/rc.d/init.d/functions

arms=/flash/egServer/elgato

[ -f "${arms}" ] || exit 0

# See how we were called.
case "$1" in
  start)
	cd /flash/egServer
        mkdir -p registry apps
        echo -n "Starting ARMS daemon: "
	${arms} -daemon -o /dev/ttyS0 -e /dev/ttyS0&

	echo
	touch /var/lock/subsys/arms
	;;
  stop)
	echo -n "Stopping ARMS daemon: "
	/usr/bin/killall -TERM elgato

	echo
	rm -f /var/lock/subsys/arms
	;;
  status)
	status arms
	;;
  restart|reload)
	echo -n "Stopping ARMS daemon: "
	/usr/bin/killall -TERM elgato

	rm -f /var/lock/subsys/arms

	cd /flash/egServer
	echo -n "Starting ARMS daemon: "
	${arms} -daemon -o /dev/ttyS0 -e /dev/ttyS0&
	
	echo
	touch /var/lock/subsys/arms
	;;
  *)
	echo "Usage: arms {start|stop|status|restart|reload}"
	exit 1
esac

exit 0
